/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AdvancedTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.BasicTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EliteTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.UltimateTableTileEntity;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;

public class RecipeMakerItem
extends BaseItem
implements IEnableable {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String NEW_LINE = System.lineSeparator() + "\t";
    private static final char[] KEYS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_*/".toCharArray();

    public RecipeMakerItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.m_41487_(1)));
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.isEnabled() && this.m_41389_(group)) {
            ItemStack stack1 = new ItemStack((ItemLike)this);
            ItemStack stack2 = new ItemStack((ItemLike)this);
            NBTHelper.setBoolean((ItemStack)stack1, (String)"Shapeless", (boolean)false);
            NBTHelper.setString((ItemStack)stack1, (String)"Type", (String)"Datapack");
            NBTHelper.setBoolean((ItemStack)stack2, (String)"Shapeless", (boolean)false);
            NBTHelper.setString((ItemStack)stack2, (String)"Type", (String)"CraftTweaker");
            items.add((Object)stack1);
            items.add((Object)stack2);
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        Level level = context.m_43725_();
        if (player == null || !player.m_36204_(pos.m_142300_(facing), facing, stack)) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (RecipeMakerItem.isTable(tile)) {
            if (level.m_5776_()) {
                String string;
                String block;
                String type = NBTHelper.getString((ItemStack)stack, (String)"Type");
                BaseItemStackHandler inventory = ((BaseInventoryTileEntity)tile).getInventory();
                String string2 = block = tile instanceof EnderCrafterTileEntity ? "EnderCrafting" : "TableCrafting";
                if ("CraftTweaker".equals(type)) {
                    string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessCraftTweakerTableRecipe((IItemHandler)inventory, block) : RecipeMakerItem.makeShapedCraftTweakerTableRecipe((IItemHandler)inventory, block);
                } else {
                    String string3 = string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessDatapackTableRecipe((IItemHandler)inventory, block) : RecipeMakerItem.makeShapedDatapackTableRecipe((IItemHandler)inventory, block);
                    if ("TOO MANY ITEMS".equals(string)) {
                        player.m_6352_((Component)Localizable.of((String)"message.extendedcrafting.max_unique_items_exceeded").args(new Object[]{KEYS.length}).build(), Util.f_137441_);
                        return InteractionResult.SUCCESS;
                    }
                }
                RecipeMakerItem.setClipboard(string);
                player.m_6352_((Component)Localizable.of((String)"message.extendedcrafting.copied_recipe").build(), Util.f_137441_);
                if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && "CraftTweaker".equals(type) && !ModList.get().isLoaded("crafttweaker")) {
                    player.m_6352_((Component)Localizable.of((String)"message.extendedcrafting.nbt_requires_crafttweaker").build(), Util.f_137441_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            if (level.m_5776_()) {
                String type = NBTHelper.getString((ItemStack)stack, (String)"Type");
                String string = "CraftTweaker".equals(type) ? RecipeMakerItem.makeCraftTweakerCombinationRecipe(core) : RecipeMakerItem.makeDatapackCombinationRecipe(core);
                RecipeMakerItem.setClipboard(string);
                player.m_6352_((Component)Localizable.of((String)"message.extendedcrafting.copied_recipe").build(), Util.f_137441_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            ItemStack stack = player.m_21120_(hand);
            NBTHelper.flipBoolean((ItemStack)stack, (String)"Shapeless");
            if (level.m_5776_()) {
                player.m_6352_((Component)Localizable.of((String)"message.extendedcrafting.changed_mode").args(new Object[]{RecipeMakerItem.getModeString(stack)}).build(), Util.f_137441_);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TYPE.args(new Object[]{NBTHelper.getString((ItemStack)stack, (String)"Type")}).build());
        tooltip.add((Component)ModTooltips.MODE.args(new Object[]{RecipeMakerItem.getModeString(stack)}).build());
    }

    public boolean isEnabled() {
        return (Boolean)ModConfigs.ENABLE_RECIPE_MAKER.get();
    }

    private static void setClipboard(String string) {
        Minecraft.m_91087_().f_91068_.m_90911_(string);
    }

    private static String makeShapedCraftTweakerTableRecipe(IItemHandler inventory, String type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.").append(type).append(".addShaped(\"").append(uuid).append("\", ");
        if ("TableCrafting".equals(type)) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int sr = (int)Math.sqrt(slots);
        for (int i = 0; i < slots; ++i) {
            TagKey tagId;
            if (i == 0 || i % sr == 0) {
                string.append("[");
            }
            ItemStack stack = inventory.getStackInSlot(i);
            Object item = "";
            if (!stack.m_41619_() && ((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && (tagId = (TagKey)stack.m_204131_().findFirst().orElse(null)) != null) {
                item = "tag:items:" + tagId.f_203868_();
            }
            if (((String)item).isEmpty()) {
                ResourceLocation id = stack.m_41720_().getRegistryName();
                item = id == null ? "item:minecraft:air" : "item:" + id;
            }
            string.append("<").append((String)item).append(">");
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.m_41619_() && stack.m_41782_() && !((String)item).startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                CompoundTag nbt = stack.m_41783_();
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            if ((i + 1) % sr != 0) {
                string.append(", ");
            }
            if (i + 1 != sr && (i + 1) % sr != 0) continue;
            string.append("]");
            if (i + 1 < slots) {
                string.append(", ");
                string.append(NEW_LINE);
                continue;
            }
            string.append(System.lineSeparator());
        }
        string.append("]);");
        return string.toString();
    }

    private static String makeShapelessCraftTweakerTableRecipe(IItemHandler inventory, String type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.").append(type).append(".addShapeless(\"").append(uuid).append("\", ");
        if ("TableCrafting".equals(type)) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        ArrayList<Integer> slotsWithItems = new ArrayList<Integer>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int lastSlot = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            slotsWithItems.add(i);
            lastSlot = i;
        }
        Iterator iterator = slotsWithItems.iterator();
        while (iterator.hasNext()) {
            ResourceLocation id;
            int i = (Integer)iterator.next();
            ItemStack stack = inventory.getStackInSlot(i);
            TagKey tagId = stack.m_204131_().findFirst().orElse(null);
            Object item = (Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get() != false && tagId != null ? "tag:items:" + tagId : ((id = stack.m_41720_().getRegistryName()) == null ? "item:minecraft:air" : "item:" + id);
            string.append("<").append((String)item).append(">");
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.m_41619_() && stack.m_41782_() && !((String)item).startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                CompoundTag nbt = stack.m_41783_();
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            if (i == lastSlot) continue;
            string.append(", ");
        }
        string.append(System.lineSeparator()).append("]);");
        return string.toString();
    }

    private static String makeCraftTweakerCombinationRecipe(CraftingCoreTileEntity tile) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("mods.extendedcrafting.CombinationCrafting.addRecipe(\"").append(uuid).append("\", <>, 100000, [").append(NEW_LINE);
        ResourceLocation inputId = tile.getInventory().getStackInSlot(0).m_41720_().getRegistryName();
        Object input = "item:minecraft:air";
        if (inputId != null) {
            input = "item:" + inputId;
        }
        string.append("<").append((String)input).append(">, ");
        ItemStack[] stacks = (ItemStack[])tile.getPedestalsWithItems().values().stream().filter(s -> !s.m_41619_()).toArray(ItemStack[]::new);
        for (int i = 0; i < stacks.length; ++i) {
            Object item;
            ItemStack stack = stacks[i];
            TagKey tagId = stack.m_204131_().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                item = "tag:items:" + tagId;
            } else {
                ResourceLocation id = stack.m_41720_().getRegistryName();
                Object object = item = id == null ? "item:minecraft:air" : "item:" + id;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && !stack.m_41619_() && stack.m_41782_() && !((String)item).startsWith("tag") && ModList.get().isLoaded("crafttweaker")) {
                CompoundTag nbt = stack.m_41783_();
                String tag = CraftTweakerUtils.writeTag(nbt);
                string.append(".withTag(").append(tag).append(")");
            }
            string.append("<").append((String)item).append(">");
            if (i == stacks.length - 1) continue;
            string.append(", ");
        }
        string.append(System.lineSeparator()).append("]);");
        return string.toString();
    }

    private static String makeShapedDatapackTableRecipe(IItemHandler inventory, String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "TableCrafting".equals(type) ? "extendedcrafting:shaped_table" : "extendedcrafting:shaped_ender_crafter");
        LinkedHashMap<Object, Character> keysMap = new LinkedHashMap<Object, Character>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_() || keysMap.keySet().stream().anyMatch(ing -> ing.test(stack))) continue;
            TagKey tag = stack.m_204131_().findFirst().orElse(null);
            char key = KEYS[keysMap.size()];
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tag != null) {
                keysMap.put(Ingredient.m_204132_((TagKey)tag), Character.valueOf(key));
            } else if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.m_41782_()) {
                keysMap.put(new NBTIngredient(stack){}, Character.valueOf(key));
            } else {
                keysMap.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), Character.valueOf(key));
            }
            if (keysMap.size() < KEYS.length) continue;
            return "TOO MANY ITEMS";
        }
        JsonArray pattern = new JsonArray();
        int size = (int)Math.sqrt(slots);
        Set keys = keysMap.entrySet();
        for (int i = 0; i < size; ++i) {
            StringBuilder line = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                ItemStack stack = inventory.getStackInSlot(i * size + j);
                Map.Entry entry = keys.stream().filter(e -> ((Ingredient)e.getKey()).test(stack)).findFirst().orElse(null);
                if (entry == null) {
                    line.append(" ");
                    continue;
                }
                line.append(entry.getValue());
            }
            pattern.add(line.toString());
        }
        object.add("pattern", (JsonElement)pattern);
        JsonObject key = new JsonObject();
        for (Map.Entry entry : keys) {
            key.add(((Character)entry.getValue()).toString(), ((Ingredient)entry.getKey()).m_43942_());
        }
        object.add("key", (JsonElement)key);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeShapelessDatapackTableRecipe(IItemHandler inventory, String type) {
        JsonObject object = new JsonObject();
        object.addProperty("type", "TableCrafting".equals(type) ? "extendedcrafting:shapeless_table" : "extendedcrafting:shapeless_ender_crafter");
        JsonArray ingredients = new JsonArray();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            TagKey tagId = stack.m_204131_().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.m_41782_()) {
                ingredients.add(new NBTIngredient(stack){}.m_43942_());
                continue;
            }
            ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}).m_43942_());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeDatapackCombinationRecipe(CraftingCoreTileEntity core) {
        ItemStack[] stacks;
        JsonObject object = new JsonObject();
        object.addProperty("type", "extendedcrafting:combination");
        object.addProperty("powerCost", (Number)100000);
        ItemStack input = core.getInventory().getStackInSlot(0);
        object.add("input", Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}).m_43942_());
        JsonArray ingredients = new JsonArray();
        for (ItemStack stack : stacks = (ItemStack[])core.getPedestalsWithItems().values().stream().filter(s -> !s.m_41619_()).toArray(ItemStack[]::new)) {
            TagKey tagId = stack.m_204131_().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_NBT.get()).booleanValue() && stack.m_41782_()) {
                ingredients.add(new NBTIngredient(stack){}.m_43942_());
                continue;
            }
            ingredients.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}).m_43942_());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("item", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static boolean isTable(BlockEntity tile) {
        return tile instanceof BasicTableTileEntity || tile instanceof AdvancedTableTileEntity || tile instanceof EliteTableTileEntity || tile instanceof UltimateTableTileEntity || tile instanceof AutoTableTileEntity || tile instanceof EnderCrafterTileEntity;
    }

    private static String getModeString(ItemStack stack) {
        return RecipeMakerItem.isShapeless(stack) ? "Shapeless" : "Shaped";
    }

    private static boolean isShapeless(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Shapeless");
    }

    private static int getGridSlots(IItemHandler inventory) {
        int slots = inventory.getSlots();
        if (slots >= 81) {
            return 81;
        }
        if (slots >= 49) {
            return 49;
        }
        if (slots >= 25) {
            return 25;
        }
        return 9;
    }
}

